/*
jQuery(document).ready(function(){

var strJsonAttributes = {{put_attributes_json("clean")}};
var strJsonItems = {{put_items_json("clean")}};

var objCharts = new UCChartsNew();

objCharts.init("{{uc_id}}", "pie", strJsonAttributes, strJsonItems);

});
*/

( () => {
  
  console.log('id: {{uc_id}}')
  
  const chartData = {
  	labels: [],
    datasets: [{
      	label: '',
      	borderRadius: '',
      	borderSkipped: '',
      	data: [],
        borderWidth: [],
      	{% if ( global_chart_type == 'line' ) or ( global_chart_type == 'radar' ) %}
          borderColor: '',
          borderWidth: '',
          pointBackgroundColor: [],
          pointBorderColor: [],
          pointBorderWidth: [], 
          pointHoverBackgroundColor: [],
          pointHoverBorderColor: [],
          pointHoverBorderWidth: [],
          {% if line_charts_border_dash != 'solid' %}
            borderDash: {{line_charts_border_dash}},
          {% endif %}
           borderCapStyle: '{{line_charts_border_cap_style}}',
           borderJoinStyle: '{{line_charts_border_line_join}}',
           stepped: {% if line_charts_line_step == 'false' %} false {% else %} '{{line_charts_line_step}}' {% endif %}, 
           tension: {{line_charts_tension_nounit}},
           pointRadius: {{line_charts_point_radius_nounit}},
           pointStyle: '{{line_charts_point_style}}',
           pointHoverRadius: {{line_charts_hover_point_radius_nounit}},
           {% if ( line_charts_fill_background == 'true') and ( global_chart_type == 'line' ) %}
             fill: {
               target: '',
               {% if line_charts_fill_area == 'origin' %}
                  above: '',
                  below: '',
               {% elseif line_charts_fill_area == 'above' %}
                  above: '',
               {% elseif line_charts_fill_area == 'below' %}
                  below: '',
               {% endif %}
             },
           {% elseif global_chart_type == 'radar'  %}
               backgroundColor: '',
           {% endif %}
           
         {% else %}
           backgroundColor: [],
           hoverBackgroundColor: [],
      		borderColor: [],
    		hoverBorderColor: [],
              hoverBorderWidth: [], 
        {% endif %}
        
    }]
  }
  
  let currentIndex = null;
  let overrideLineColor = false
  let overridePointStyling = false
  let datasetLineStyling = {};
  let datasetPointStyling = {};    

  const items = JSON.parse({{put_items_json("clean")}});
 
  items.forEach( (item, index) => {   
    
	if ( item.item_type == 'dataset' ) {
      
    	if ( index == 0 ) {
          currentIndex = index
        } else {
          currentIndex += 1;
        }
      	
      	overridePointStyling = false
        overrideLineColor = false
      	
      	if (item.data_set_override_point_styling == "true" ) {
        	overridePointStyling = true
        	datasetPointStyling.pointBackgroundColor = item.data_set_point_styles_background_color
            datasetPointStyling.pointBorderColor = item.data_set_point_styles_border_color
            datasetPointStyling.pointBorderWidth = Number(item.data_set_point_styles_border_width)
            datasetPointStyling.pointHoverBackgroundColor = item.data_set_point_styles_hover_background_color
            datasetPointStyling.pointHoverBorderColor = item.data_set_point_styles_hover_border_color
            datasetPointStyling.pointHoverBorderWidth = Number(item.data_set_point_styles_hover_border_width)
        }
        
        if ( item.data_set_override_line_color == "true" ) {
          overrideLineColor = true
          datasetLineStyling.color = item.data_set_line_color
        }
        
        if ( chartData.datasets[currentIndex] ) {
        	chartData.datasets[currentIndex].label = item.dataset_label
            {% if ( global_chart_type == 'line' ) or ( global_chart_type == 'radar' ) %}
            	chartData.datasets[currentIndex].borderWidth = {{line_charts_border_width}}
          		if ( overrideLineColor ) {
                  chartData.datasets[currentIndex].borderColor = datasetLineStyling.color
                }
          		
            {% endif %}
            {% if global_chart_type == 'bar' %} 
                chartData.datasets[currentIndex].borderRadius = item.data_set_bar_border_radius_nounit 
                chartData.datasets[currentIndex].borderSkipped = false
            {% endif %}
            
        } else {
          
        	chartData.datasets.push({
              label: item.dataset_label,
              data: [],
              {% if ( global_chart_type == 'line' ) or ( global_chart_type == 'radar' ) %}
                    /*backgroundColor: [],*/
                    borderColor: '',
                    borderWidth: {{line_charts_border_width}},
              		pointBackgroundColor: [],
              		pointBorderColor: [],
             		pointBorderWidth: [], 
              		pointHoverBackgroundColor: [],
              		pointHoverBorderColor: [],
              		pointHoverBorderWidth: [],
             		{% if line_charts_border_dash != 'solid' %}
             	  		borderDash: {{line_charts_border_dash}},
                	{% endif %}
                	borderCapStyle: '{{line_charts_border_cap_style}}',
                	borderJoinStyle: '{{line_charts_border_line_join}}',
                	stepped: {% if line_charts_line_step == 'false' %} false {% else %} '{{line_charts_line_step}}' {% endif %}, 
                	tension: {{line_charts_tension_nounit}},
                	pointRadius: {{line_charts_point_radius_nounit}},
                	pointStyle: '{{line_charts_point_style}}',
                	pointHoverRadius: {{line_charts_hover_point_radius_nounit}},
                    {% if ( line_charts_fill_background == 'true') and ( global_chart_type == 'line' ) %}
                     fill: {
                       target: '',
                       {% if line_charts_fill_area == 'origin' %}
                          above: '',
                          below: '',
                       {% elseif line_charts_fill_area == 'above' %}
                          above: '',
                       {% elseif line_charts_fill_area == 'below' %}
                          below: '',
                       {% endif %}
                     },
                   {% elseif global_chart_type == 'radar' %}
                   	  backgroundColor: '',
                   {% endif %}
              {% else %}
                	backgroundColor: [],
                	borderColor: [],
                	borderWidth: [],
                	hoverBackgroundColor: [],
                	hoverBorderColor: [],
                	hoverBorderWidth: [],
                    {% if global_chart_type == 'bar' %} 
                		borderRadius: item.data_set_bar_border_radius_nounit,
                		borderSkipped: false,
            		{% endif %}
             {% endif %}
          })
            
        }
        
    } else {
      
      if ( currentIndex == 0 ) {
      	chartData.labels.push(item.data_item_label)
        
      }
      
     const dataValue = item.data_item_value.toString().replace(/,/g, '.')
      chartData.datasets[currentIndex].data.push(Number(dataValue))
      
      {% if ( global_chart_type == 'line' ) or ( global_chart_type == 'radar' ) %}

		if ( overridePointStyling ) {
          chartData.datasets[currentIndex].pointBackgroundColor.push(datasetPointStyling.pointBackgroundColor)
          chartData.datasets[currentIndex].pointBorderColor.push(datasetPointStyling.pointBorderColor)
          chartData.datasets[currentIndex].pointBorderWidth.push(datasetPointStyling.pointBorderWidth) 
          chartData.datasets[currentIndex].pointHoverBackgroundColor.push(datasetPointStyling.pointHoverBackgroundColor)
          chartData.datasets[currentIndex].pointHoverBorderColor.push(datasetPointStyling.pointHoverBorderColor)
          chartData.datasets[currentIndex].pointHoverBorderWidth.push(datasetPointStyling.pointHoverBorderWidth)
        } else {
          chartData.datasets[currentIndex].pointBackgroundColor.push(item.data_item_background_color)
          chartData.datasets[currentIndex].pointBorderColor.push(item.data_item_border_color)
          chartData.datasets[currentIndex].pointBorderWidth.push(Number(item.data_item_border_width)) 
          chartData.datasets[currentIndex].pointHoverBackgroundColor.push(item.data_item_hover_background_color)
          chartData.datasets[currentIndex].pointHoverBorderColor.push(item.data_item_hover_border_color)
          chartData.datasets[currentIndex].pointHoverBorderWidth.push(Number(item.data_item_hover_border_width))  
        }
        
       	
       	{% if global_chart_type == 'line' %}

          if ( chartData.datasets[currentIndex].borderColor == '') {
            chartData.datasets[currentIndex].borderColor = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color	
          }
          {% if line_charts_fill_background == 'true' %}
            if ( chartData.datasets[currentIndex].fill.target == '' ) { 
              chartData.datasets[currentIndex].fill.target =  '{{line_charts_fill_area}}'
              {% if line_charts_fill_area == 'origin' %}
                  chartData.datasets[currentIndex].fill.above = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color
                  chartData.datasets[currentIndex].fill.below = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color
              {% elseif line_charts_fill_area == 'above' %}
                chartData.datasets[currentIndex].fill.above = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color
              {% elseif line_charts_fill_area == 'below' %}
                chartData.datasets[currentIndex].fill.below = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color
              {% endif %}
            }
          {% endif %}
        {% elseif global_chart_type == 'radar' %}

            if ( chartData.datasets[currentIndex].borderColor == '') {
              chartData.datasets[currentIndex].borderColor = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color	
            }
        	if ( {{line_charts_fill_background}} ) {
              if ( !chartData.datasets[currentIndex].backgroundColor ) {
        		chartData.datasets[currentIndex].backgroundColor = overrideLineColor ? datasetLineStyling.color : item.data_item_background_color
              }
            } else {
              if ( !chartData.datasets[currentIndex].backgroundColor) {
            	chartData.datasets[currentIndex].backgroundColor = 'transparent'
              }
            }
	    {% endif %}
        
       
      {% else %}
      
        chartData.datasets[currentIndex].backgroundColor.push(item.data_item_background_color)
        chartData.datasets[currentIndex].borderColor.push(item.data_item_border_color) 
      	chartData.datasets[currentIndex].borderWidth.push(Number(item.data_item_border_width)) 
        chartData.datasets[currentIndex].hoverBackgroundColor.push(item.data_item_hover_background_color)
        chartData.datasets[currentIndex].hoverBorderColor.push(item.data_item_hover_border_color) 
        chartData.datasets[currentIndex].hoverBorderWidth.push(Number(item.data_item_hover_border_width))  
        
     {% endif %}
   }
       
 })
 
  const chartOptions = {
  	maintainAspectRatio: false,
    {% if enable_animation == 'false' %} 
  	  animation: {{enable_animation}}, 
    {% endif %}
    interaction: {
      intersect: {{interactions_intersect}},
      mode: '{{interactions_mode}}',
      axis: 'xy',
    },
    {% if ( global_chart_type == 'line' ) or ( global_chart_type == 'bar' ) %}
    	indexAxis: '{{direction}}',
    {% endif %}
    {% if ( global_chart_type == 'bar' ) and ( bar_width_type == 'custom' ) %}
    	barThickness: {{custom_bar_width_nounit}},
    {% endif %}
    scales: {
    	x: {
          display: {{show_x_axis_line}},
          grid: {
            display: {{show_grid_lines}},
            color: '{{grid_lines_color_x_axis}}',
            drawTicks: {{show_grid_ticks}},
            tickColor: '{{ticks_color_x_axis}}',
            borderColor: '{{line_color_x_axis}}',
            beginAtZero: {{begin_at_zero_x}}
          },
          ticks: {
            color: '{{label_color_x_axis}}',
            font: {
              size: {{label_font_size_x_axis_nounit}},
              weight: '{{label_font_weight_x_axis}}',
              style: '{{label_font_style_x_axis}}'
            },
            padding: {{ticks_padding_x_axis_nounit}}
          },
          {% if global_chart_type == 'bar' %}
          	stacked: {{stack_bars}},
          {% endif %}
        },
        y: {
          display: {{show_y_axis_line}},
          grid: {
            display: {{show_grid_lines}},
            color: '{{grid_lines_color_y_axis}}',
            drawTicks: {{show_grid_ticks}},
            tickColor: '{{ticks_color_y_axis}}',
            borderColor: '{{line_color_y_axis}}',
            beginAtZero: {{begin_at_zero_y}}
          },
          ticks: {
            color: '{{label_color_y_axis}}',
            font: {
              size: {{label_font_size_y_axis_nounit}},
              weight: '{{label_font_weight_y_axis}}',
              style: '{{label_font_style_y_axis}}'
            },
            padding: {{ticks_padding_y_axis_nounit}},
            {% if add_prefix_suffix == 'true' %}
            	 callback: function(value, index, ticks) {
                   return '{{ticks_prefix|raw}}' + value + '{{ticks_suffix|raw}}';
                 }
            {% endif %}
          },
          {% if global_chart_type == 'bar' %}
          	stacked: {{stack_bars}},
          {% endif %}
        },
        {% if global_chart_type == 'radar' %}
          r: {
              display: {{show_angle_lines}},
              color: '{{angle_line_color}}'
          },
        {% endif %}   
    },
    plugins: {
      legend: {
        display: {{show_legend}},
        position: '{{legend_position}}',
        labels: {
          usePointStyle: {{legend_use_point_style}},
          pointStyle: '{{legend_point_style}}',
          color: '{{legend_label_color}}',
          padding: {{legend_padding_nounit}},
          font: {
            size: {{label_font_size_nounit}},
            style: '{{label_font_style}}',
            weight: '{{label_font_weight}}'
          },
          boxWidth: {{legent_point_style_width_nounit}},
          boxHeight: {{legent_point_style_height_nounit}}
        },
      },
        tooltip: {
          enabled: {{tooltip_enabled}},
          backgroundColor: '{{tooltip_background_color}}',
          bodyColor: '{{tooltip_body_color}}',
          bodyAlign: '{{tooltip_body_align}}',
          bodyFont: {
            size: {{tooltip_body_font_size}},
            weight: '{{tooltip_body_font_weight}}'
          },
          borderColor: '{{tooltip_border_color}}',
          borderWidth: {{tooltip_border_width_nounit}},
          titleColor: '{{tooltip_title_color}}',
          titleAlign: '{{tooltip_title_align}}',
          titleFont: {
            size: {{tooltip_title_font_size}},
            weight: '{{tooltip_title_font_weight}}'
          },
          cornerRadius: {{tooltip_corner_radius}},
          padding: {{tooltip_padding}},
          	callbacks: {
              {% if ( global_chart_type == 'pie' ) or ( global_chart_type == 'doughnut' ) or ( global_chart_type == 'polarArea' ) %}
                title: function(context) {
                  return context[0].dataset.label
                },
              {% endif %}
              {% if tooltip_show_percentage == 'true' %}
            	label: function(context) {
                  
                  let total = context.dataset.data.reduce( (previous, next) => {
                    return Math.abs(previous) + Math.abs(next)
                  })
                  
                  const currentValue = Math.abs(context.formattedValue)
                  return `${context.label}: ${((currentValue/total)*100).toFixed(2)}%`
                },
              {% endif %}
              {% if add_prefix_suffix == 'true' %}
            	 label: function(context) {
                   return context.label + ': ' + '{{ticks_prefix|raw}}' + context.formattedValue + '{{ticks_suffix|raw}}';
                 }
            {% endif %}
        	},
            
         /* {% if ( global_chart_type == 'pie' ) or ( global_chart_type == 'doughnut' ) or ( global_chart_type == 'polarArea' ) %}
            callbacks: {
              label: function(context) {
                console.log('context', context)
                const label = context.dataset.label;
                return `${label}: ${context.label}: ${context.formattedValue}`
              }
        	}
         {% endif %} */
           
		}
    },
    
 }
      
	
  const canvas =  document.querySelector('#{{uc_id}}')
  const options = {
  	canvasContainer: document.querySelector('#{{uc_id}}'),
    canvas: canvas.querySelector('.uc-chart__canvas'),
    globalChartType: '{{global_chart_type}}',
    chartData: chartData,
    chartOptions: chartOptions
  }
  
  console.log('options', options)
  
  //const chart_{{uc_id}} = new UeCharts(options)
  
   const chart_{{uc_id}} = new Chart(options.canvas,{
            type: options.globalChartType,
            data: options.chartData,
			options: options.chartOptions
        })
  
}) ();