#{{uc_id}} .ue-google-map__wrapper .gm-svpc>div>img 
{
  max-width: unset;
}

#{{uc_id}} .ue-google-map_navigator-toggle
{
  display:none;
}

#{{uc_id}} 
{
  display: flex;
  flex-direction: column;
  position: relative;
  height: 100%;
}

#{{uc_id}} .ue-google-map__info-window
{
  display: flex;
  flex-direction: column;
  flex-wrap: wrap;
  
}


#{{uc_id}} .ue-google-map_container {
  display: flex;
    flex-wrap: wrap;
  
}

#{{uc_id}} .ue-google-map_places-wrapper {
  max-height: 100%;
  overflow: hidden;
  display:flex;
  flex-direction:column;
}

#{{uc_id}} .ue-google-map_search-wrapper {
	width: 100%;
    position: relative;
  
}

#{{uc_id}} .ue-google-map_search-input-wrapper {
	position: relative;
}

#{{uc_id}} .ue-google-map_search-icon {
	position: absolute;
    top: 50%;
    right: 10px;
    transform: translateY(-50%);
    cursor: pointer;
}

#{{uc_id}} .uc-map-error-message {
   position:absolute;
   top:-27px;
   left:0px;
   direction:ltr;
   color:red;
   font-size:16px;
}
  
#{{uc_id}} .uc-google-map__overlays {
	flex-grow: 1;
    display:flex;
  	height: 100%;
    position:relative;	
}

#{{uc_id}} .ue-google-map__wrapper {
	flex-grow: 1;
    width: auto;
  	height: auto;
    position:relative;
}

#{{uc_id}} .ue-google-map_places-list {
  
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
  overflow: auto;
  max-height: 100%;
}

#{{uc_id}} .ue-google-map_places-item
{
  display:flex;
  position:relative;
  align-items:center;
  overflow:hidden;
  cursor:pointer;
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-maps-navigator-item-image
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-maps-navigator-item-image-spacing
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-maps-navigator-item-spacing
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-maps-navigator-item-spacing:last-child
{
  display:none;
}

.ue-maps-navigator-item-title
{
  font-size:21px;
}

.ue-maps-navigator-item-sub-title
{
  font-size:12px;
}


#{{uc_id}} .ue-maps-navigator-item-image img
{
  display:block;
}

#{{uc_id}} .ue-maps-navigator-item-background-image
{
  position:absolute;
  top:0;
  bottom:0;
  left:0;
  right:0;
  width:100%;
  height:100%;
  object-fit: cover;
}

#{{uc_id}} .ue-maps-navigator-item-background-overlay
{
  position:absolute;
  top:0;
  bottom:0;
  left:0;
  right:0;
  width:100%;
  height:100%;
  
}

#{{uc_id}} .ue-maps-navigator-item-content
{
  position:relative;
  flex-grow:1;
}

#{{uc_id}} .ue-google-map__info-window-img img
{
 width:100%; 
}

.ue-google-map_places-hidden-placeholders {
	display: none;
}

{% if show_the_locator_tool == "true" %}
  .ue-google-map__locator-tool 
  {
    background-image: linear-gradient(90deg, #6f00d8 0%, #1c6aff 100%);
    color: #ffffff;
    width: 100%;
    padding: 15px;
    position:relative;
    font-size:14px;
  }

.ue-google-map__locator-tool-marker-details
{
  display:flex;
  gap:20px;
  flex-wrap:wrap;
}

  .ue-google-map__locator-tool-address, .ue-google-map__locator-tool-latitude, .ue-google-map__locator-tool-longitude, .ue-google-map__locator-tool-notes
  {
    display: flex;
    align-items: center;
    width: 25%;
    gap: .2em;
  }
  
  .ue-google-map__locator-tool-latitude, .ue-google-map__locator-tool-longitude 
  {
    width: 20%;
  }
	
  .ue-google-map__locator-tool-address label 
  {
    width: 90%;
  }

  .ue-google-map__locator-tool input
  {
    margin-top: .5em;
    border-radius: 5px;
  }

  .ue-google-map__locator-tool i 
  {
    font-size: 1.2em;
    transform: translateY(50%) scale(1);
    cursor: pointer;
  }
	
  .ue-google-map__locator-tool i:hover
  {
    animation: ue-pulse 1.6s infinite alternate ease-in-out;
  }

  @keyframes ue-pulse
  {
    0% { transform: translateY(50%) scale(1); }
    50% { transform: translateY(50%) scale(1.2); }
    100% { transform: translateY(50%) scale(1); }
  }

  .ue-google-map__locator-tool-latitude input::-webkit-outer-spin-button,
  .ue-google-map__locator-tool-latitude input::-webkit-inner-spin-button,
  .ue-google-map__locator-tool-longitude input::-webkit-outer-spin-button,
  .ue-google-map__locator-tool-longitude input::-webkit-inner-spin-button,
  .ue-google-map__locator-tool-current-location-wrapper input::-webkit-outer-spin-button,
  .ue-google-map__locator-tool-current-location-wrapper input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
  }

  /* Firefox */
  .ue-google-map__locator-tool-latitude input[type=number],
  .ue-google-map__locator-tool-longitude input[type=number],
  .ue-google-map__locator-tool-current-latitude input[type=number],
  .ue-google-map__locator-tool-current-longitude input[type=number]{
    -moz-appearance: textfield;
  }

  .ue-google-map__locator-tool-zoom {
    width: 10%;
  }

  .ue-google-map__locator-tool-notes {
    width: 15%;
  }

  .ue-google-map__locator-tool-current-location-wrapper {
    border-top: 1px solid rgba(255,255,255,0.5);
    width: 100%;
    gap: 30px;
    display: flex;
    align-items: center;
    padding-top: 10px;
    margin-top: 10px;
    display:none;
  }
  
  .ue-google-map__locator-tool-current-location-wrapper div {
    width: fit-content;
    display: flex;
  }

.ue-google-map__locator-tool-current-location-wrapper .ue-google-map__locator-hide-show-marker {
  font-size:14px;
}

.ue-google-map__locator-tool-current-location-wrapper .ue-google-map__locator-hide-show-marker span {
  	line-height:1em;
}

.ue-google-map__locator-tool-header
{
  display:flex;
  justify-content:space-between;
  padding-bottom:15px;
}

.ue-google-map__locator-tool-toggles
{
  display:flex;
  gap:15px;
}

.ue-google-map__locator-hide-show-marker .ue-google-map__locator-hide-marker,
.ue-google-map__locator-hide-show-marker.uc_active .ue-google-map__locator-show-marker {
  opacity: 0;
  display:none;
}

.ue-google-map__locator-hide-show-marker .ue-google-map__locator-show-marker,
.ue-google-map__locator-hide-show-marker.uc_active .ue-google-map__locator-hide-marker {
  opacity: 1;
  display:block;
}





{% endif %}


.ue-google-map__info-window-title
{
  font-size:21px;
}


@media screen and (max-width: {{responsive_breakpoint}}px) {
  
  #{{uc_id}} .ue-google-map_container
  {
    flex-direction:column;
  }
  
  #{{uc_id}} .ue-google-map_places-wrapper
  {
    display:none;
    position:absolute;
    top:0px;
    width:100%;
    height: calc(100% - 44px);
    bottom:0px;
    left:0px;
    right:0px;
    z-index:1;
  }
  
  #{{uc_id}} .ue-google-map_places-wrapper.uc_active {
  	display: flex;
  }
  
  
  #{{uc_id}} .ue-google-map_navigator-toggle
    {
      display:block;
      z-index: 2;
      position:absolute;
      bottom:0;
      width:100%;
      
    }
 
}

#{{uc_id}} .ue-google-map__error-overlay
{
  display: none;
  align-items: center;
  justify-content: center;
  width: 100%;
  height: 100%;
  position: absolute;
  inset: 0;
}

#{{uc_id}} .ue-google-map__error-overlay:before
{
  	content: ' ';
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(90deg, #6f00d8 0%, #1c6aff 100%);
    z-index: 1;
    opacity: 0.7;
}
#{{uc_id}} .ue-google-map__error-overlay-content
{
	width: 70%;
  	height: 70%;
  	background: #ffffff;
  color: #000000;
  padding: 1.2em;
  z-index: 2;
  position: relative;
}

#{{uc_id}} .ue-google-map__error-overlay-title,
#{{uc_id}} .ue-google-map__error-overlay-geocoded-value,
#{{uc_id}} .ue-google-map__error-overlay-status,
#{{uc_id}} .ue-google-map__error-overlay-close-btn:hover
{
	color: #ff0000;
}

#{{uc_id}} .ue-google-map__error-overlay-close-btn
{
    font-size: 2em;
    position: absolute;
    top: 0;
    right: 5%;
  	cursor: pointer;
}

#{{uc_id}} span.ue-google-map__info-icon
{
  line-height:1em;
}

#{{uc_id}} span.ue-google-map__info-icon svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue-google-map_reset-btn
{
  border:none;
  position:absolute;
  {{vertical_snap}}:{{vertical_distance}}px;
  {{horizontal_snap}}:{{horizontal_distance}}px;
  z-index:1;
  display:flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  box-shadow: rgb(0 0 0 / 30%) 0px 1px 4px -1px;
 
}

.ue-google-map_reset-btn svg
{
  height:1em;
  width:1em;
}


#{{uc_id}} .ue-google-map_category
{
  display:flex;
  flex-direction: column;
}

#{{uc_id}} .ue-google-map_category-content
{
	display: flex;
}

#{{uc_id}} .ue-google-map_category-title
{
	display: flex;
    gap: 0.5em;
    width: 100%;
}

#{{uc_id}} .ue-google-map_category-checkbox
{
  flex-grow:0;
  flex-shrink:0;
  display:flex;
  align-items:center;
}

#{{uc_id}} .ue-google-map_category-name
{
  flex-grow:1;
  cursor: pointer;
}

#{{uc_id}} .ue-google-map_category-toggle
{
  flex-grow:0;
  flex-shrink:0;
  cursor: pointer;
}

#{{uc_id}} .ue-google-map_category-checkbox-spacing
{
  width:10px;
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-google-map_navigator-toggle
{
  cursor:pointer;
  text-align:center;
}

#{{uc_id}} .ue-google-map_category-toggle
{
  position: relative;
  width: 15%;
}

#{{uc_id}} .ue-google-map_category-toggle .ue-google-map_category-toggle-icon
{
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  transition: opacity 0.4s ease-out;
}

#{{uc_id}} .ue-google-map_category-toggle .ue-google-map_category-toggle-close {
  opacity: 0;
}

#{{uc_id}} .ue-google-map_category-toggle.ue_active .ue-google-map_category-toggle-close
{
  opacity: 1;
}

#{{uc_id}} .ue-google-map_category-toggle .ue-google-map_category-toggle-open 
{
	opacity: 1;
}

#{{uc_id}} .ue-google-map_category-toggle.ue_active .ue-google-map_category-toggle-open
{
  opacity: 0;
}
#{{uc_id}} .ue-google-map_category-items
{
  overflow: hidden;
  transition: max-height 0.6s ease-in-out;
}

.ue_shimmer {
    animation: ue_shimmer 2.2s linear infinite forwards;
    background: #ddd;
    background-image: linear-gradient(to right, #F6F6F6 8%, #F0F0F0 18%, #F6F6F6 33%);
    background-size: 200% 100%;
}

@keyframes ue_shimmer {
    0% {
        background-position: 200% 0;
    }
    100% {
        background-position: -200% 0;
    }
}

.ue-google-map__loader {
	position: absolute;
  	inset: 0;
    width: 100%;
    height: 100%;
  	z-index: 3;
  	transform-origin: 100% 0%;
  	transition: transform 0.6s ease-out;
}


#{{uc_id}} .uc-checkbox{
	position: absolute; overflow: hidden; clip: rect(0 0 0 0); 
    height:1px; width:1px; margin:-1px; padding:0;border:0;
}

#{{uc_id}} .uc-checkbox + label{
	display:block;
    border-radius:2px;
	padding:1px;
	width:17px;
	height:17px;
    background:{{checkbox_background}};
    cursor:pointer;
}

#{{uc_id}} .uc-checkbox + label svg{
	display:none;
}

#{{uc_id}} .uc-checkbox:checked + label svg{
	display:inline-block;
}