{% set apiKey = ucfunc("get_general_setting","google_map_key")%}

{%if apiKey == ""%}
  <div class="uc-error-message">
      Google Map API Key not found. Please set it in General Settings - Integrations tab.       	
  </div>
{%else%}

  {% if ucfunc("run_code_once","google_map_script") %}
    <script
        src="https://maps.googleapis.com/maps/api/js?key={{apiKey}}&{% if ( language == 'custom' ) %}language={{language_code|raw}}&{%endif%}callback=ucInitMaps&libraries=&v=weekly"
        async
    ></script>
    <script>
       var g_arrInitCallbacks = [];
       var g_isGoogleMapInited = false;

       function ucInitMaps(){
           g_isGoogleMapInited = true;
           if(g_arrInitCallbacks.length == 0)
             return(false);

           for(index in g_arrInitCallbacks)
             g_arrInitCallbacks[index]();
      }
    </script>
  {% endif %}

{% set currentCategory = 0 %}
{{ ucfunc("set","currentCategory",currentCategory) }}
{% set itemsTotal = uc_num_items %}
{{ ucfunc("set","itemsTotal",itemsTotal) }}
{% set categoryExist = "false" %}
{{ ucfunc("set","categoryExist",categoryExist) }}

  <div id="{{uc_id}}" class="ue-google-map">
    <div class="ue-google-map__loader ue_shimmer"></div>
    {% if show_the_locator_tool == "true" %}
      <div class="ue-google-map__locator-tool">
        <div class="ue-google-map__locator-tool-header">
         <div class="ue-google-map__locator-tool-note">* Search for coordinates by address and copy the Longitude and Latitude into your maps settings</div>
         
         <div class="ue-google-map__locator-tool-toggles">
               <div class="ue-google-map__locator-hide-show-marker">
                 
                  <span class="ue-google-map__locator-show-marker" title="Hide Tool Marker">
                    <i class="fas fa-eye"></i>
                  </span>
                 
                  <span class="ue-google-map__locator-hide-marker" title="Show Tool Marker">
                    <i class="fas fa-eye-slash"></i>
                  </span>
                
           </div>
                
                <div class="ue-google-map__locator-hide-show-map-current" title="Show / Hide Map Coordinates"><i class="fas fa-map"></i></div>
          </div>
        </div>
     <div class="ue-google-map__locator-tool-marker-details">
        <div class="ue-google-map__locator-tool-address">
          <label>Marker Address: 
             <input type="text" value="New York"/>
          </label>
          <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Address" aria-role="button" aria-roledescription="Copy Address Button" tabindex="0" data-copy="adrress"></i>
          <i class="ue-google-map__locator-tool-address__search eicon-arrow-right" aria-label="Geocode Address" aria-role="button" aria-roledescription="Geocode Address to latitude and longitude" tabindex="0"></i>
        </div>
        <div class="ue-google-map__locator-tool-latitude">
          <label>Marker Latitude: 
             <input type="number"/>
          </label>
          <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Latitude" aria-role="button" aria-roledescription="Copy Latitude Button" tabindex="0" data-copy="latitude"></i>
        </div>
        <div class="ue-google-map__locator-tool-longitude">
          <label>Marker Longitude: 
             <input type="number"/>
          </label>
          <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Longitude" aria-role="button" aria-roledescription="Copy longitude Button" tabindex="0" data-copy="longitude"></i>
          <i class="ue-google-map__locator-tool-longitude__search eicon-arrow-right" aria-label="Geocode Coordinates" aria-role="button" aria-roledescription="Geocode latitude and longitude to address" tabindex="0"></i>
        </div>
        <div class="ue-google-map__locator-tool-zoom">
          <label>Zoom: 
             <input type="number" min="1" max="24" step="1"/>
          </label>
        </div>
        <div class="ue-google-map__locator-tool-notes">
          <label>Notes: 
             <input type="text" placeholder="type a note..."/>
          </label>
        </div>
        
          
       
        </div>
        
        
        
        <div class="ue-google-map__locator-tool-current-location-wrapper">
          <div class="ue-google-map__locator-tool-current-latitude">
            <label>Map Current Latitude: 
              <input type="number" class="cft-transparent" />
            </label>
            <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Current Latitude" aria-role="button" aria-roledescription="Copy Current Latitude Button" tabindex="0" data-copy="current-latitude"></i>
          </div>
          <div class="ue-google-map__locator-tool-current-longitude">
            <label>Map Current Longitude: 
              <input type="number" class="cft-transparent"/>
            </label>
            <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Current Longitude" aria-role="button" aria-roledescription="Copy Current longitude Button" tabindex="0" data-copy="current-longitude"></i>
          </div>
        
        </div>
        
        
        
      </div>
    {% endif %}
    <div class="ue-google-map_container">
      {% if navigation == "before"  %}
        <div class="ue-google-map_places-wrapper" {% if show_the_locator_tool == "true" %} style="opacity: 0;" {% endif %}>
          {% if show_places_search == "true" %}
          <div class="ue-google-map_search-wrapper">
            <div class="ue-google-map_search-input-wrapper">
              <input tabindex="0" id="mapSearch" class="ue-google-map_search-input" type="text" placeholder="{{search_placeholder|raw}}">
              <i aria-label="Search" aria-role="button" aria-roledescription="Search Map Items" tabindex="0" class="ue-google-map_search-icon eicon-search"></i>
            </div>
          </div>
          {% endif %}
    
          <div tabindex="0" class="ue-google-map_places-list">
            {{put_items()}}
          </div>
        </div>
      {% endif %}   
      
      <div class="uc-google-map__overlays">
        
        {% if show_map_reset_button == "true" %}
          	<button class="ue-google-map_reset-btn" aria-label="Reset" aria-role="button" aria-roledescription="Reset Map" tabindex="0" title="Reset Map">{{reset_button_icon_html|raw}}</button>
        {% endif %}
        
        <div aria-label="Map" aria-role="application" aria-roledescription="map" class="ue-google-map__wrapper">
        </div>
      </div>
      
      
      
      
     
      
      
      {% if navigation == "after"  %}
        <div class="ue-google-map_places-wrapper" {% if show_the_locator_tool == "true" %} style="opacity: 0;" {% endif %}>
          {% if show_places_search == "true" %}
          <div class="ue-google-map_search-wrapper">
            <div class="ue-google-map_search-input-wrapper">
              <input tabindex="0" id="mapSearch" class="ue-google-map_search-input" type="text" placeholder="{{search_placeholder|raw}}">
              <i aria-label="Search" aria-role="button" aria-roledescription="Search Map Items" tabindex="0" class="ue-google-map_search-icon eicon-search"></i>
            </div>
          </div>
          {% endif %}
          
          <div tabindex="0" class="ue-google-map_places-list">
            {{put_items()}}
          </div>
        </div>
      {% endif %}
      
      
      {% if navigation == "before" %}
       <div class="ue-google-map_navigator-toggle" data-open-text="{{open_navigator|raw}}" data-close-text="{{close_navigator|raw}}" >{{open_navigator|raw}}</div>
      {% endif %}
      {% if navigation == "after" %}
       <div class="ue-google-map_navigator-toggle" data-open-text="{{open_navigator|raw}}" data-close-text="{{close_navigator|raw}}" >{{open_navigator|raw}}</div>
      {% endif %}
        
      
    </div>
    <div class="ue-google-map_places-hidden-placeholders">
         {{put_items2()}}
    </div>
    <div class="ue-google-map__error-overlay">
      <div class="ue-google-map__error-overlay-content">
        <span class="ue-google-map__error-overlay-close-btn">×</span>
        <h3 class="ue-google-map__error-overlay-title">Geocoding Error Occured.</h3>
        <p>Tried to Geocode: <span class="ue-google-map__error-overlay-geocoded-value"></span></p>
        <p>Error Type: <span class="ue-google-map__error-overlay-status"></span></p>
        <p>Please be sure to follow the tutorial on how to setup the Google APIs required for the Advanced Google Map Widget.</p>
        <a href="https://unlimited-elements.com/docs/google-map-api-key/">Google Map API Key Tutorial </a>
      </div>
    </div>
  </div>
{%endif%}