(() => {
  
function ucObserveMap() {
	const observer = new IntersectionObserver( entries => {
      for( const entry of entries ) {
          if(entry.isIntersecting) { 
              ucRunGoogleMap{{uc_serial}}()
              observer.disconnect()
          }
      }
    })
    
  	observer.observe( document.querySelector('#{{uc_id}}') )
}

function ucInitGoogleMap{{uc_serial}}() {
  {% if load_on_screen_entry == 'true' %}
    ucObserveMap()
  {% else %}
	if (jQuery('#{{uc_id}}').is(':hidden') ) {
      console.log('{{uc_id}} hidden')
      ucObserveMap()
    } else {	
      console.log('{{uc_id}} not hidden')
 		ucRunGoogleMap{{uc_serial}}()
    }
  {% endif %}
}

function ucRunGoogleMap{{uc_serial}}() {

  const categories = document.querySelectorAll('#{{uc_id}} .ue-google-map_category').forEach( category => {
  	const itemsTotal = category.querySelectorAll('.ue-google-map_places-item').length
    category.querySelector('.ue-google-map_category-items-count').textContent = `(${itemsTotal})`
  })

  const markersJsonItems = {{put_items_json()}};
  const markersItems = JSON.parse(markersJsonItems);
  const infoWindowItems = document.querySelectorAll('#{{uc_id}} .ue-google-map__info-window');

	let currentCategory = 0;
	
	markersItems.forEach( item => {
    	
      if( item.item_type == 'category' ) {
          
        currentCategory++
        item.category_index = currentCategory
            
      } else if ( item.item_type == 'place' ) {
        
        if ( currentCategory == 0 ) {
          item.category_index = null
        }
          
        item.category_index = currentCategory
        
      }
    })

  let mapStyle;

{% if (style_category == "google") %} 
    {% if (google_styles != "standard") %} 
        mapStyle = '{{uc_assets_url}}' + '{{google_styles}}'
      {% else %}
        mapStyle = null
      {% endif %}
  {% elseif  (style_category == "custom") %}
    mapStyle = {{custom_map_style|raw}}
  {% endif %}

  options = {
    dom: document.querySelector('#{{uc_id}} .ue-google-map__wrapper'),
    assetsURL: '{{uc_assets_url}}',
    mapType: '{{map_type}}',
    mapOptions: {
        zoom: {{zoom_level_nounit}},
        center: {
            lat: {% if (latitude != "") %} parseFloat('{{latitude|raw}}'.replace(',','.')) {% else %}null{% endif %},
            lng: {% if (longitude != "") %} parseFloat('{{longitude|raw}}'.replace(',','.')) {% else %}null{% endif %},
        },
        address: {% if (address != "") %} '{{address|raw}}' {% else %} 'New York' {% endif %} 
    },
    mapControls: {
        mapTypeControl: {{show_map_type}},
        mapTypeControlOptions: {
            style: '{{map_type_control_style}}',
            mapTypeIds: [ {% for value in map_types %} 
                          '{{value}}',
                        {% endfor %}
                        ]
  },
    zoomControl: {{show_zoom}},
    streetViewControl: {{show_streetview}},
    rotateControl: {{show_rotate}},
    scaleControl: {{show_scale}},
    fullscreenControl: {{show_fullscreen}}
  },
  mapStyleCategory: '{{style_category}}',
  mapStyle: mapStyle,
  markers: markersItems,
  infoWindowOptions: {
    showInfoWindow: {{show_info_window}},
    openByDefault: {{open_by_default}}
  },
  infoWindowContent: infoWindowItems,
  finderTool: {
    show: {{show_the_locator_tool}},
    wrapper: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool'),
    latitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-latitude input'),
    longitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-longitude input'),
    addressEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-address input'),
    addressBtnEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-address .ue-google-map__locator-tool-address__search'),
    copyIcons: document.querySelectorAll('#{{uc_id}} .ue-google-map__locator-tool .ue-google-map__locator-tool__button-copy'),
    geocodeCoordinatesIcon: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-longitude .ue-google-map__locator-tool-longitude__search'),
    zoomEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-zoom input'),
    notesEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-notes input'),
    currentWrapper: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-location-wrapper'),
    currentWrapperToggle: document.querySelector('#{{uc_id}} .ue-google-map__locator-hide-show-map-current'),
    currentLatitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-latitude input'),
    currentLongitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-longitude input'),
    currentZoomEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-zoom input'),
    debugMarkerIcon: '{{uc_assets_url}}' + 'unlimited_elements_icon.png',
    markerToggleEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-hide-show-marker')
  },
  defaultMarker: {
    icon_type: '{{default_marker_icon_type}}',
    marker_list_icon: '{{default_marker_icon}}',
    marker_custom_icon: '{{default_marker_custom_image}}',
    icon_letter: '{{default_marker_icon_letter}}',
    marker_width_nounit: '{{default_marker_width_nounit}}',
    marker_height_nounit: '{{default_marker_height_nounit}}',
    ue_svg_marker: '{{ue_svg_marker}}',
    animate_marker: {{animate_marker}}
  },
  clustering: {
    show: {{use_marker_cluster}},
    imagesPath: '{{uc_assets_url}}' + 'img/clustering',
    maxZoom: {{cluster_max_zoom}},
    gridSize: {{cluster_grid_size}}
  },
  navigation: {
    showPlaces: {% if navigation == "hide" %} false {% else %} true {% endif %},
    showSearch: {{show_places_search}},
    places: document.querySelectorAll('#{{uc_id}} .ue-google-map_navigator-item'),
    searchInput: document.querySelector('#{{uc_id}} .ue-google-map_search-input'),
    searchIcon: document.querySelector('#{{uc_id}} .ue-google-map_search-icon'),
    resetButton: document.querySelector('#{{uc_id}} .ue-google-map_reset-btn'),
    showReset: {{show_map_reset_button}},
    placesWrapper: document.querySelector('#{{uc_id}} .ue-google-map_places-wrapper'),
    placesToggle: document.querySelector('#{{uc_id}} .ue-google-map_navigator-toggle'),
    categoryToggleClass: '.ue-google-map_category-toggle-icon',
    categoryTitleClass: '.ue-google-map_category-name',
    categoryCheckboxClass: '.ue-google-map_category-checkbox input',
    placeItemsClass: '.ue-google-map_category-items'
  },
  errorOverlay: {
      wrapper: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay'),
      closeButton: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay-close-btn'),
      geocodedValueEl: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay-geocoded-value'),
      statusEl: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay-status'),
  },
  loader: document.querySelector('#{{uc_id}} .ue-google-map__loader'),
  breakpoint: {{responsive_breakpoint}},
  container: document.querySelector('#{{uc_id}}'),
  isEditMode: {% if uc_inside_editor == "yes" %} true {% else %} false {% endif %}
}                 
                                                
  const map_{{uc_id}} = new UeGoogleMapWidget(options);
                                                                                
  {% if enable_map_interaction_inside_elementor_editor == 'true' %}
    document.querySelector('#{{uc_id}}').parentElement.addEventListener('mousedown', (e) => { e.stopPropagation() });
  {% endif %}  
  
 
  
}

   
jQuery(document).ready(function(){	
function {{uc_id}}_start(){

if(g_isGoogleMapInited == true ) {
 ucInitGoogleMap{{uc_serial}}();
} else {
 g_arrInitCallbacks.push(ucInitGoogleMap{{uc_serial}});
}

    	
}if(jQuery("#{{uc_id}}").length) {{uc_id}}_start(); else
	jQuery( document ).on( 'elementor/popup/show', () => { if(jQuery("#{{uc_id}}").length) {{uc_id}}_start();});
});
   
})();